// Pixel shader input structure
struct PS_INPUT
{
    float4 Position   : POSITION;			// UNUSED
    float2 Texture0   : TEXCOORD0;
    float2 Texture1   : TEXCOORD1;
};

// Pixel shader output structure
struct PS_OUTPUT
{
    float4 Color   : COLOR0;
};

sampler2D Tex0 : register(s0);				// This is the contents of the screen from the last full draw frame
sampler2D Tex1 : register(s1);				// This is the result of the image produced from wave.psh

PS_OUTPUT main( in PS_INPUT In )
{ 
    PS_OUTPUT Out;
	
    float4 aWave = tex2D(Tex1, In.Texture1);    
    float4 anOrigColor = tex2D(Tex0, In.Texture0);    
	In.Texture0.x += (0.50196 - aWave.r) * 0.1;				
	In.Texture0.y += ((0.50196 - aWave.g) * (0.1 * 1.5));			    
    Out.Color = lerp(anOrigColor, tex2D(Tex0, In.Texture0), saturate(aWave.b + aWave.b + aWave.b + aWave.b));    

    return Out;
}

technique Default
{
	pass P0
	{
		PixelShader = compile ps_2_0 main();
	}
}
